<?php

namespace App\Providers;

use App\Http\Interfaces\AddressRepositoryInterface;
use App\Http\Interfaces\AttenanceSettingRepoitoryInterface;
use App\Http\Interfaces\AttendDetailsRepositoryInterface;
use App\Http\Interfaces\AttendMethodRepositoryInterface;
use App\Http\Interfaces\BranchEmployeesRepositoryInterface;
use App\Http\Interfaces\BranchRepositoryInterface;
use App\Http\Interfaces\CategoryRepositoryInterface;
use App\Http\Interfaces\ClientRepositoryInterface;
use App\Http\Interfaces\CompanyRepositoryInterface;
use App\Http\Interfaces\CountryRepositoryInterface;
use App\Http\Interfaces\DayRepositoryInterface;
use App\Http\Interfaces\EmployeeAttendancesRepositoryInterface;
use App\Http\Interfaces\EmployeeRepositoryInterface;
use App\Http\Interfaces\EmployeeTransferRepositoryInterface;
use App\Http\Interfaces\FingerprintReportRepositoryInterface;
use App\Http\Interfaces\JobDepartmentRepositoryInterface;
use App\Http\Interfaces\JobRepositoryInterface;
use App\Http\Interfaces\ProductRepositoryInterface;
use App\Http\Interfaces\ServiceRepositoryInterface;
use App\Http\Interfaces\SupplierRepositoryInterface;
use App\Http\Interfaces\WarehouseRepositoryInterface;
use App\Http\Repositories\AddressRepository;
use App\Http\Repositories\AttenanceSettingRepoitory;
use App\Http\Repositories\AttendDetailsRepository;
use App\Http\Repositories\AttendMethodRepository;
use App\Http\Repositories\BranchEmployeesRepository;
use App\Http\Repositories\BranchRepository;
use App\Http\Repositories\CategoryRepository;
use App\Http\Repositories\ClientRepository;
use App\Http\Repositories\CompanyRepository;
use App\Http\Repositories\CountryRepository;
use App\Http\Repositories\DayRepository;
use App\Http\Repositories\EmployeeAttendancesRepository;
use App\Http\Repositories\EmployeeRepository;
use App\Http\Repositories\EmployeeTransferRepository;
use App\Http\Repositories\FingerprintReportRepository;
use App\Http\Repositories\JobDepartmentRepository;
use App\Http\Repositories\JobRepository;
use App\Http\Repositories\ProductRepository;
use App\Http\Repositories\ServiceRepository;
use App\Http\Repositories\SupplierRepository;
use App\Http\Repositories\WarehouseRepository;
use Illuminate\Support\ServiceProvider;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->bind(JobDepartmentRepositoryInterface::class, JobDepartmentRepository::class);
        $this->app->bind(JobRepositoryInterface::class, JobRepository::class);
        $this->app->bind(BranchRepositoryInterface::class, BranchRepository::class);
        $this->app->bind(CountryRepositoryInterface::class, CountryRepository::class);
        $this->app->bind(AddressRepositoryInterface::class, AddressRepository::class);
        $this->app->bind(EmployeeRepositoryInterface::class, EmployeeRepository::class);
        $this->app->bind(BranchEmployeesRepositoryInterface::class, BranchEmployeesRepository::class);
        $this->app->bind(EmployeeTransferRepositoryInterface::class, EmployeeTransferRepository::class);
        $this->app->bind(AttendMethodRepositoryInterface::class, AttendMethodRepository::class);
        $this->app->bind(DayRepositoryInterface::class, DayRepository::class);
        $this->app->bind(AttendDetailsRepositoryInterface::class, AttendDetailsRepository::class);
        $this->app->bind(EmployeeAttendancesRepositoryInterface::class, EmployeeAttendancesRepository::class);
        $this->app->bind(FingerprintReportRepositoryInterface::class, FingerprintReportRepository::class);
        $this->app->bind(AttenanceSettingRepoitoryInterface::class, AttenanceSettingRepoitory::class);
        $this->app->bind(WarehouseRepositoryInterface::class, WarehouseRepository::class);
        $this->app->bind(SupplierRepositoryInterface::class, SupplierRepository::class);
        $this->app->bind(ClientRepositoryInterface::class, ClientRepository::class);
        $this->app->bind(CategoryRepositoryInterface::class, CategoryRepository::class);
        $this->app->bind(ServiceRepositoryInterface::class, ServiceRepository::class);
        $this->app->bind(ProductRepositoryInterface::class, ProductRepository::class);
        $this->app->bind(CompanyRepositoryInterface::class, CompanyRepository::class);
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}
