<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\AttenanceSettingRepoitoryInterface;
use App\Models\AttendanceSetting;
use App\Models\Deduction;

class AttenanceSettingRepoitory implements AttenanceSettingRepoitoryInterface
{
    public function first()
    {
        return AttendanceSetting::first();
    }

    
    public function updateSetting($data, $id)
    {
        if (AttendanceSetting::first() == null) {

            return AttendanceSetting::create($data);
        }

        $setting = AttendanceSetting::findOrFail($id);
        $setting->update($data);

        return $setting;
    }
    
    public function storeDeduction($data)
    {
        
    }
    
    public function updateDeduction($data)
    {
        $delay_period = $data['delay_period'];
        $value = $data['value'];
        $count = count($value);

        Deduction::where('attendance_setting_id', $data['attendance_setting_id'])->delete();

        for ($i=0; $i<$count; $i++) {
            Deduction::create([
                'attendance_setting_id' => $data['attendance_setting_id'],
                'delay_period' => $delay_period[$i],
                'value' => $value[$i]
            ]);
        }
    }

    
}
