<?php

namespace App\Http\Repositories;

use App\Models\Client;
use App\Http\Interfaces\ClientRepositoryInterface;

class ClientRepository implements ClientRepositoryInterface
{
    public function getAll()
    {
        return Client::with(['address.area.city.country', 'favoriteEmployee'])->get();
    }

    public function create($data)
    {
        return Client::create($data);
    }

    public function update($data,  $client)
    {
        return $client->update($data);
    }

    public function delete($client)
    {
        return $client->delete();
    }
}
