<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\EmployeeTransferRepositoryInterface;
use App\Models\Branch;
use App\Models\EmployeeTransfer;
use App\Models\User;

class EmployeeTransferRepository implements EmployeeTransferRepositoryInterface
{
    public function all()
    {
        return EmployeeTransfer::all();
    }
    
    public function paginate($count)
    {
        return EmployeeTransfer::paginate($count);
    }

    public function store($data)
    {
        foreach ($data['employees'] as $employeeId) {

            $employee = User::findOrFail($employeeId);
            $previousBranch = Branch::findOrFail($data['previous_branch']);
            $nextBranch = Branch::findOrFail($data['next_branch']);

            $employee->branches()->detach($previousBranch);
            $employee->branches()->attach($nextBranch);

            EmployeeTransfer::create([
                'previous_branch_id' => $data['previous_branch'],
                'employee_id' => $employeeId,
                'next_branch_id' => $data['next_branch'],
                'temporary' => isset($data['temporary']) ? 1 : 0,
                'end_date' => $data['end_date']  ?? null,
            ]);
        }
    }

    public function destroy($id)
    {
        return EmployeeTransfer::findOrFail($id)->delete();
    }
}