<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\ProductRepositoryInterface;
use App\Models\Product;

class ProductRepository implements ProductRepositoryInterface
{
    public function getAll()
    {
        $products = Product::with('category')->get();
        return $products;
    }
    public function create($request)
    {
        $product = Product::create($request->validated());

        return $product;
    }
    public function update($request, Product $product)
    {
        $product->update($request->validated());
        return $product;
    }
    public function delete(Product $product)
    {
        $product->delete();
    }
}
