<?php

namespace App\Http\Repositories;

use App\Models\Service;
use App\Http\Interfaces\ServiceRepositoryInterface;

class ServiceRepository implements ServiceRepositoryInterface
{
    public function getAll()
    {
        $services = Service::with('category')->get();
        return $services;
    }
    public function create($request)
    {
        $service = Service::create($request->validated());

        return $service;
    }
    public function update($request, Service $service)
    {
        $service->update($request->validated());
        return $service;
    }
    public function delete(Service $service)
    {
        $service->delete();
    }
}
