<?php

namespace App\Http\Repositories;

use App\Models\Supplier;
use App\Http\Interfaces\SupplierRepositoryInterface;

class SupplierRepository implements SupplierRepositoryInterface
{
    public function getAll()
    {
        // return Supplier::first();
        return Supplier::with(['address', 'company'])->get();
    }

    public function show($supplier)
    {
        return $supplier->load(['address', 'company']);
    }

    public function store($data)
    {
        return Supplier::create($data);
    }

    public function update($supplier, $data)
    {
        return $supplier->update($data);
    }

    public function delete($supplier)
    {
        return $supplier->delete();
    }
}
