<?php

namespace App\Http\Services\Bill;

use App\Models\Journal;
use App\Http\Enums\Bill\BillEnum;
use App\Trait\BillJournalEntryTrait;
use App\Http\Services\Bill\BillService;

class BillJournalEntryService
{
    use BillJournalEntryTrait;

    private $billService;

    public function __construct(BillService $billService)
    {
        $this->billService = $billService;
    }

    public function createJournalEntries($status)
    {
        if ($this->billService->bill->type === BillEnum::sales->value) {
            $this->createSalesJournalEntries($status);
        } else {
            $this->createPurchaseJournalEntries($status);
        }
    }
}
