<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreBranchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'place_en' => 'required',
            'place_ar' => 'required',
            'work_type_id' => 'required',
            'employee_count_id' => 'required',
            'country_id' => 'required',
            'city_id' => 'required',
            'area_id' => 'required',
            'address_en' => 'required',
            'address_ar' => 'required',
            'longitude' => 'required',
            'latitude' => 'required',
            'post_code' => 'required',
            'phone_one' => 'required',
            'phone_two' => 'required',
            'email' => 'required',
            'website' => 'required',
            'manager_fname' => 'required',
            'manager_lname' => 'required',
            'gender' => 'required',
            'home_service' => 'nullable',
            'beauty_expert' => 'nullable',
            'delivers' => 'nullable',
        ];
    }
}
