<?php
namespace App\Http\Requests\Supplier;

use App\Models\Address;
use App\Models\Supplier;
use Illuminate\Foundation\Http\FormRequest;

class StoreSupplierRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return array_merge(Supplier::ROLES, Address::ROLES);
    }

    public function prepareForValidation()
    {
        // dd('hello');
        $code = (Supplier::latest()->first()->getOriginal('code') ?? 100) + 1;
        // dd($code);
        $this->merge([
            // 'address_line' => ['ar' => $this->address_ar, 'en' => $this->address_en,],
            'status' => $this->status == 'on' ? true : false,
            'code' => "$code",
        ]);
    }
}
