<?php

namespace App\Http\Requests\Supplier;

use App\Models\Address;
use App\Models\Supplier;
use Illuminate\Foundation\Http\FormRequest;

class UpdateSupplierRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return array_merge(Supplier::ROLES, Address::ROLES);
    }

    public function prepareForValidation()
    {
        $code = $this->supplier->code;
        $this->merge([
            'status' => $this->status == 'on' ? true : false,
            'code' => "$code",
        ]);
    }
}
