<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateEmployeeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $userId = request()->user()->id;
        
        return [
            'name_ar' => 'required|max:255',
            'name_en' => 'required|max:255',
            'code' => 'required|integer',
            'phone' => ['required', Rule::unique('users')->ignore($userId, 'id'),],
            'email' => ['required', Rule::unique('users')->ignore($userId, 'id'),],
            'birth_date' => 'required|date',
            'id_type' => 'nullable|in:0, 1', // 0 =  passport .. 1 = national id
            'id_no' => 'required',
            'attendance_method' => 'nullable',
            'Job_id' => 'nullable|exists:jobs,id',
            'hired_at' => 'required|date',
            'country_id' => 'nullable',
            'city_id' => 'nullable|exists:countries,id',
            'area_id' => 'nullable|exists:countries,id',
            'post_code' => 'required',
            'address_ar' => 'required|max:255',
            'address_en' => 'required|max:255',
            'status' => 'nullable',
            'appear_in_calendar' => 'nullable',
            'has_imprint' => 'nullable',
            'online_booking' => 'nullable',
        ];
    }
}
