<?php

namespace App\Http\Requests\client;

use App\Models\Client;
use Illuminate\Foundation\Http\FormRequest;

class StoreClientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return Client::RULES;
    }

    public function prepareForValidation()
    {
        $last_code = Client::withTrashed()->latest()->first()->code ?? 200;

        $this->merge([
            'favorite_employee_id' => null,
            'status' => $this->status ? true : false,
            'client' => $this->client ? true : false,
            'cache' => $this->cache ? true : false,
            'internet' => $this->internet ? true : false,
            'fingerprint' => $this->fingerprint ? true : false,
            'code' => $last_code + 1,
            'gender' => $this->gender == 1 ? 'male' : 'female',
            'address_line' => ['ar' => $this->address_ar, 'en' => $this->address_en,],
        ]);

        // dd($this->all());
    }
}
