<?php

namespace App\Http\Requests\client;

use App\Models\Client;
use Illuminate\Foundation\Http\FormRequest;

class UpdateClientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return Client::RULES;
    }

    public function prepareForValidation()
    {

        $this->merge([
            'favorite_employee_id' => null,
            'status' => $this->status ? true : false,
            'client' => $this->client ? true : false,
            'cache' => $this->cache ? true : false,
            'internet' => $this->internet ? true : false,
            'fingerprint' => $this->fingerprint ? true : false,
            'address_line' => [
                'ar' => $this->address_ar,
                'en' => $this->address_en
            ],
        ]);
    }
}
