<?php

namespace App\Http\Requests\product;

use App\Models\Product;
use Illuminate\Foundation\Http\FormRequest;

class StoreProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return array_merge(Product::RULES, [
            'code' => 'required',
        ]);
    }

    public function prepareForValidation()
    {
        $last_code = Product::withTrashed()->latest()->first()->code ?? 200;
        $this->merge([
            'code' => $last_code + 1,
            'has_expiry_date' => $this->has_expiry_date == 'on',
        ]);
    }
}
