<?php

namespace App\Http\Requests\product;

use App\Models\Product;
use Illuminate\Foundation\Http\FormRequest;

class UpdateProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return Product::RULES;
    }

    public function prepareForValidation()
    {
        $this->merge([
            'has_expiry_date' => $this->has_expiry_date == 'on',
        ]);
    }
}
