<?php

namespace App\Http\Requests\service;

use App\Models\Service;
use Illuminate\Foundation\Http\FormRequest;

class UpdateServiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return Service::RULES;
    }

    public function prepareForValidation()
    {
        $last_code = Service::withTrashed()->latest()->first()->code ?? 200;
        $this->merge([
            'status' => $this->status == 'on',
            'fast' => $this->fast == 'on',
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en
            ],
            'description' => [
                'ar' => $this->description_ar,
                'en' => $this->description_en,
            ],
        ]);
    }
}
