<?php

namespace App\Http\Requests\warehouse;

use App\Models\Warehouse;
use Illuminate\Foundation\Http\FormRequest;

class StoreWarehouseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return array_merge(Warehouse::RULES, [
            'code' => 'required|integer|unique:warehouses,code',
        ]);
    }

    public function prepareForValidation()
    {
        $last_code = Warehouse::withTrashed()->latest()->first()->code ?? 200;

        $this->merge([
            // 'branch_id' => $this->branch->id,
            'code' => $last_code + 1,
            'status' => $this->status == 'on' ? 1 : 0,
        ]);
        // dd(Warehouse::withTrashed()->latest()->first(), $last_code, $this->all());
    }
}
