<?php

namespace App\Exports;

use App\Models\Category;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Events\AfterSheet;

class CategoryExport implements FromCollection, WithHeadings, WithEvents
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return collect([]);
    }

    public function headings(): array
    {
        return [
            'Name',
            'Description',
            'Fast Categories',
            'Status',
        ];
    }
    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet;
                $this->arrayToDropDownListIncExcelColumn($sheet, $this->getTrueORFalseOptions(), 'C', 1000);
                $this->arrayToDropDownListIncExcelColumn($sheet, $this->getTrueORFalseOptions(), 'D', 1000);
            },
        ];
    }
    private function arrayToDropDownListIncExcelColumn($sheet, $array, $column, $numberOfRows)
    {
        for ($i = 2; $i <= $numberOfRows; $i++) {
            $cell = $sheet->getDelegate()->getCell($column . $i);
            $objValidation = $cell->getDataValidation();
            $objValidation->setType(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST);
            $objValidation->setErrorStyle(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_INFORMATION);
            $objValidation->setAllowBlank(false);
            $objValidation->setShowInputMessage(true);
            $objValidation->setShowErrorMessage(true);
            $objValidation->setShowDropDown(true);
            $objValidation->setFormula1('"' . implode(',', $array) . '"');
        }
    }
    private function getTrueORFalseOptions(): array
    {
        return ['نعم', 'لا'];
    }
}
