<?php

namespace App\Http\Controllers\Api\Admin\Admin;

use App\Models\Admin;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\AdminResource;
use App\Http\Requests\Api\Admin\StoreAdminRequest;
use App\Http\Requests\Api\Admin\UpdateAdminRequest;

class AdminController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: AdminResource::collection(Admin::where('id', '!=', auth('admin')->id())->get()),
        );
    }

    public function store(StoreAdminRequest $request)
    {
        return $this->apiResponse(
            data: AdminResource::make(Admin::create($request->validated())),
            message: __('messages.admin_created_successfully'),
        );
    }

    public function show(Admin $admin)
    {
        return $this->apiResponse(
            data: AdminResource::make($admin),
        );
    }

    public function update(UpdateAdminRequest $request, Admin $admin)
    {
        $admin->update($request->validated());
        return $this->apiResponse(
            data: AdminResource::make($admin),
            message: __('messages.admin_updated_successfully'),
        );
    }

    public function destroy(Admin $admin)
    {
        $admin->delete();
        return $this->apiResponse(
            message: __('messages.admin_deleted_successfully'),
        );
    }
}
