<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\MetaRequest;
use App\Http\Resources\MetaResource;
use App\Models\Meta;
use Illuminate\Http\Request;

class MetaController extends Controller
{
    public function index()
    {
        return $this->apiResponse(data: MetaResource::collection(Meta::all()));
    }
    public function show(Meta $meta)
    {
        return $this->apiResponse(data: MetaResource::make($meta));

    }
    public function store(MetaRequest $request)
    {
        return $this->apiResponse(data: MetaResource::make(Meta::create($request->validated())), message: __('messages.meta_created_successfully'));
    }
    public function update(MetaRequest $request, Meta $meta)
    {
        $meta->update($request->validated());
        return $this->apiResponse(data: MetaResource::make($meta), message: __('messages.meta_updated_successfully'));
    }
    public function destroy(Meta $meta)
    {
        $meta->delete();
        return $this->apiResponse(message: __('messages.meta_deleted_successfully'));
    }
}
