<?php

namespace App\Http\Controllers\Api\Admin\Setting;

use App\Models\Setting;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\SettingResource;
use App\Http\Enums\Setting\SettingTypeEnum;
use App\Http\Requests\Admin\Setting\SettingRequest;
use App\Trait\UploadFileTrait;

class SettingController extends Controller
{
    use ApiTrait, UploadFileTrait;

    public function index()
    {
        return $this->apiResponse(data: SettingResource::collection(Setting::get()));
    }

    public function update(Setting $setting, SettingRequest $request)
    {
        if ($setting->type == SettingTypeEnum::STRING) {
            $value = $request->value;
        } elseif ($setting->type == SettingTypeEnum::FILE) {
            $value = $this->uploadFile(Setting::UPLOADED_FILES, $request->value, $setting->value);
        }

        $setting->update(['value' => $value]);

        return $this->apiResponse(message: __('messages.setting_updated_successfully'));
    }
}
