<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StepRequest;
use App\Http\Resources\StepResource;
use App\Models\Step;
use Illuminate\Http\Request;

class StepController extends Controller
{

    public function index()
    {
        return $this->apiResponse(data: StepResource::collection(Step::all()));
    }

    public function update(StepRequest $request)
    {
        foreach ($request->steps as $step) {

            Step::where('number', $step['number'])->update([
                'status' => $step["status"],
            ]);
        }
        return $this->apiResponse(message: __('messages.steps_updated_successfully'));
    }
}
