<?php

namespace App\Http\Controllers\Api\Admin\Unit;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Admin\Unit\UnitRequest;
use App\Http\Resources\UnitResource;
use App\Models\MainUnit;

class UnitController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: UnitResource::collection(MainUnit::get()),
        );
    }

    public function store(UnitRequest $request)
    {
        return $this->apiResponse(
            data: UnitResource::make(MainUnit::create($request->validated())),
            message: __('messages.unit_created_successfully')
        );
    }

    public function show(MainUnit $mainUnit)
    {
        return $this->apiResponse(
            data: UnitResource::make($mainUnit),
        );
    }

    public function update(UnitRequest $request, MainUnit $mainUnit)
    {
        $mainUnit->update($request->validated());

        return $this->apiResponse(
            data: UnitResource::make($mainUnit),
            message: __('messages.unit_updated_successfully')
        );
    }

    public function destroy(MainUnit $mainUnit)
    {
        $mainUnit->delete();
        return $this->apiResponse(
            message: __('messages.unit_deleted_successfully')
        );
    }
}
