<?php

namespace App\Http\Controllers\Api\Auth;

use App\Models\Company;
use App\Models\Worker;
use App\Trait\ApiTrait;
use App\Trait\UploadFileTrait;
use Illuminate\Http\Request;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\UserResource;
use App\Http\Resources\WorkerResource;
use App\Http\Resources\PackageResource;
use App\Http\Resources\PermissionResource;
use App\Http\Requests\Api\Company\ProfileRequest;
use App\Http\Resources\StepResource;
use App\Models\Step;
use App\Http\Resources\ShiftResource;
use Illuminate\Support\Facades\Hash;

class ProfileController extends Controller
{
    use ApiTrait, UploadFileTrait;

    public function loggedInUser()
    {
        $company = CompanyHelper::getCompany();

        $packageWithFeatures = $company->companyCurrentPackageWithFeatures() ?: null;

      $shift = null;

if (auth('worker')->check()) {
    $worker = auth('worker')->user();
    
    $shift = $worker->shifts()
        ->whereNull('close_name')
        ->latest()
        ->first();
    
    if ($shift) {
        $shift->load([
            'branch:id,name', // Only fetch id and name from branch
            'employee:id,name', // Only fetch id and name from employee
        ]);
    }
}
        return $this->apiResponse(data: [
            'company' => UserResource::make($company),
            'user' => $this->currentUser($company),
            'shift' => $shift ? ShiftResource::make($shift): null,
            'permissions' => $this->getWorkerPermissions(),
            'active_package' => $packageWithFeatures ? PackageResource::make($packageWithFeatures) : null,
            'steps' => StepResource::collection(Step::where('status', true)->orderBy('number')->get()),

        ]);
    }

    public function updateProfile(ProfileRequest $request)
    {
        $validatedData = $request->validated();
        if ($request->has('password')) {
            $validatedData['password'] = Hash::make($request->validated(['password']));
        }
        if ($request->hasFile('logo')) {
            $validatedData['logo'] = $this->uploadFile(Company::UPLOADED_FILES, $request->logo);
        }
        CompanyHelper::getCompany()->update($validatedData);

        return $this->apiResponse(message: 'Profile updated successfully');
    }

    private function currentUser($company)
    {
        if (auth('worker')->check()) {
            return WorkerResource::make(Worker::with('employee')->where('id', auth('worker')->id())->first());
        }

        return UserResource::make($company);
    }

    private function getWorkerPermissions()
    {
        if (auth('worker')->check()) {
            return PermissionResource::collection(request()->user()->getAllPermissions());
        }

        return [];
    }
}
