<?php

namespace App\Http\Controllers\Api\Auth;

use App\Models\Company;
use App\Models\Package;
use App\Trait\ApiTrait;
use App\Events\NewCompany;
use App\Jobs\MakeSubscription;
use App\Trait\UploadFileTrait;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use App\Http\Services\Subscription\SubscriptionService;
use App\Http\Requests\Api\Company\RegisterCompanyRequest;

class RegisterController extends Controller
{
    use ApiTrait, UploadFileTrait;

    public function register(RegisterCompanyRequest $request)
    {
        $logo = null;

        if ($request->has('logo')) {
            $logo = $this->uploadFile(Company::UPLOADED_FILES, $request->logo);
        }
        $companyExists = Company::where('email', $request->input('email'))
            ->whereNull('email_verified_at')
            ->exists();


        if ($companyExists) {
            $company = Company::where('email', $request->input('email'))->first();
            unset($request->validated()['free_package']);
            $company->update(
                [
                    'logo' =>
                    $logo,
                    'password' => Hash::make($request->password),
                    'steps_completed' => 0,
                ] + $request->validated()
            );
        } else {
            $company = Company::create(
                [
                    'logo' =>
                    $logo,
                    'password' => Hash::make($request->password),
                    'steps_completed' => 0,
                ] + $request->validated()
            );
        }


        event(new NewCompany($company));

        $warring = $request->free_package ? SubscriptionService::handleFreePackageSubscription(company: $company) : null;

        return $this->apiResponse(
            message: __('messages.registration_success_with_verification_code_sent'),
            warring: $warring,
        );
    }
}
