<?php

namespace App\Http\Controllers\Api\Bill;

use App\Models\Bill;
use App\Trait\ApiTrait;
use App\Http\Helper\CompanyHelper;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Resources\BillResource;
use App\Http\Services\Bill\BillService;
use Illuminate\Validation\ValidationException;
use App\Http\Requests\Api\Bill\StoreBillRequest;
use App\Http\Requests\Api\Bill\UpdateBillRequest;
use App\Http\Requests\OrdersRequest;
use App\Http\Services\Bill\BillJournalEntryService;
use App\Models\Client;
use App\Models\Supplier;

class BillController extends Controller
{
    use ApiTrait;

    public function index($type, $billType)
    {
         $returnValue = request()->query("is_returned", 0);
        return $this->apiResponse(
            data: BillResource::collection(
                CompanyHelper::getCompany(request())->bills()->where('type', $type)->where('category', $billType)
                ->where("is_returned", "=", $returnValue)
                ->where('fast_sales', false)
                ->when(auth('worker')->check(), function ($query) {
                    $query->where('worker_id', auth('worker')->user()->id);
                })->with([
                    'journals.entries.account',
                    'journals.entries.type',
                    'branch',
                    'warehouse',
                    'delivery',
                    'sellNature.selling',
                    'billProducts.product',
                    'billServices.service',
                    'billProducts.tax',
                    'billPaymentMethods.payment',
                    'billPaymentMethods.paymentMethod',
                    'billServices.tax',
                    'billProducts.unit',
                    'billable',
                    'billExpenses.expense',
                ])->get()
            )
        );
    }
    public function getFastSalesInvoices()
    {
        $this->authorize('view fast bill sales');
        return $this->apiResponse(
            data: BillResource::collection(
                CompanyHelper::getCompany(request())->bills()->where('fast_sales', true)->when(auth('worker')->check(), function ($query) {
                    $query->where('worker_id', auth('worker')->user()->id);
                })->with([
                    'journals.entries.account',
                    'journals.entries.type',
                    'branch',
                    'warehouse',
                    'delivery',
                    'billPaymentMethods.payment',
                    'billPaymentMethods.paymentMethod',
                    'sellNature.selling',
                    'billProducts.product',
                    'billServices.service',
                    'billProducts.tax',
                    'billServices.tax',
                    'billProducts.unit',
                    'billable',
                    'billExpenses.expense',
                ])->get()
            )
        );
    }
    public function show($type, $billType, Bill $bill)
    {


        $bill->load([
            'journals.entries.account',
            'journals.entries.type',
            'branch',
            'warehouse',
            'delivery',
            'billPaymentMethods.payment',
            'billPaymentMethods.paymentMethod',
            'sellNature.selling',
            'billProducts.product.units',
            'billServices.service',
            'billProducts.tax',
            'billServices.tax',
            'billProducts.unit',
            'billable',
            'billExpenses.expense',
        ]);
        return $this->apiResponse(data: new BillResource($bill));
    }
    public function store(StoreBillRequest $request, $type, $billType)
    {
        $billService = (new BillService);

        DB::transaction(function () use ($request,  $billService, $billType) {

            $billService->billProcess(request: $request, type: 'store', billType: $billType);
            if ($request->has('order_id')) {
                Bill::find($request->order_id)->delete();
            }

            if ($billService->bill->isAccredited()) {
                (new BillJournalEntryService($billService))->createJournalEntries($request->bill_details['status']);
            }
        });

        return $this->apiResponse(message: __('messages.bill_created_successfully'), data: BillResource::make($billService->bill));
    }
    
    //     public function store(StoreBillRequest $request, $type, $billType)
    // {
    //     $billService = (new BillService);
    //     DB::transaction(function () use ($request, $billService, $billType) {
    //         $billService->billProcess(request: $request, type: 'store', billType: $billType);
    //         // if ($request->has('order_id')) {
    //         //     $bill = Bill::find($request->order_id);
    //         //     if ($bill) {
    //         //         $bill->delete();
    //         //     }
    //         // }
            
    //           if ($request->has('order_id')) {
    //             $bill = Bill::find($request->order_id);
    //             $is_returned=$request->input('bill_details.is_returned');
    //              if ($bill) {
                   
    //             // dd($is_returned);
    //                     if ($is_returned == 1) {
    //                         $bill->update([
    //                             'returned_bill' => true,
    //                             ]);
    //                     } elseif($is_returned==0) {
    //                         $bill->delete();
    //                     }
                    
    //             }
               
    //         }
           
    //         if ($billService->bill->isAccredited()) {
    //             (new BillJournalEntryService($billService))->createJournalEntries($request->bill_details['status']);
    //         }
    //     });

    //     return $this->apiResponse(message: __('messages.bill_created_successfully'), data: BillResource::make($billService->bill));
    // }
    public function update(UpdateBillRequest $request, $type, $billType, Bill $bill)
    {
        if ($bill->fast_sales) {
            $this->authorize('edit fast bill sales');
        } else {
            if ($bill->isAccredited()) {
                throw ValidationException::withMessages([
                    'bill' => [__('messages.bill_cannot_update')]
                ]);
            } else {
                $this->authorize('edit Sales Orders');
            }
        }

        DB::transaction(function () use ($request, $bill,$billType) {
            $billService = (new BillService)->setBill($bill)->billProcess(request: $request, type: 'update',billType: $billType);

           if ($billService->bill->isAccredited()) {
                (new BillJournalEntryService($billService))->createJournalEntries();
            }
        });

        return $this->apiResponse(message: __('messages.bill_updated_successfully'));
    }
    public function destroy($type, $billType, Bill $bill)
    {
        if ($bill->fast_sales) {
            $this->authorize('delete fast bill sales');
        } else {
            if ($bill->isAccredited()) {
                $this->authorize('delete bills');
            } else {
                $this->authorize('delete Sales Orders');
            }
        }
        $bill->delete();
        return $this->apiResponse(message:__('messages.bill_deleted_successfully'));
    }
    // public function getOrders(OrdersRequest $request, $id)
    // {
    //     $type = $request->validated()['type'];
    //     $bills = Bill::where('status', 'draft')
    //         ->where('category', 'order')
    //         ->where('billable_id', $id)
    //         ->when($type === 'client', function ($query) {

    //             return $query->where('billable_type', Client::class)->where('type', 'sales');
    //         })
    //         ->when($type === 'supplier', function ($query) {

    //             return $query->where('billable_type', Supplier::class)->where('type', 'purchases');;
    //         })->with([
    //             'branch',
    //             'warehouse',
    //             'delivery',
    //             'billPaymentMethods.payment',
    //             'billPaymentMethods.paymentMethod',
    //             'sellNature.selling',
    //             'billProducts.product',
    //             'billServices.service',
    //             'billProducts.tax',
    //             'billServices.tax',
    //             'billProducts.unit',
    //             'billable',
    //             'billExpenses.expense',
    //         ])->get();
    //     return   $this->apiResponse(
    //         data: BillResource::collection($bills)
    //     );
    // }
    
        public function getOrders(OrdersRequest $request, $id)
    {
        $type = $request->validated()['type'];
        $category = $request->validated()['category'];
        // dd($category);
        $bills = Bill::where('category', $category)
            ->where('billable_id', $id)
            // ->where('is_returned', 0)
            ->when($type === 'client', function ($query) {

                return $query->where('billable_type', Client::class)->where('type', 'sales');
            })
            ->when($type === 'supplier', function ($query) {

                return $query->where('billable_type', Supplier::class)->where('type', 'purchases');
                
            })->when($category === 'invoice', function ($query) {
            return $query->where('status', 'accredited');
            })
            ->with([
                    'branch',
                    'warehouse',
                    'delivery',
                    'billPaymentMethod.payment',
                    'billPaymentMethod.paymentMethod',
                    'billPaymentMethods.paymentMethod',
                    'sellNature.selling',
                    'billProducts.product',
                    'billServices.service',
                    'billProducts.tax',
                    'billServices.tax',
                    'billProducts.unit',
                    'billable',
                    'billExpenses.expense',
                ])->get();
        return $this->apiResponse(
            data: BillResource::collection($bills)
        );
    }
}
