<?php

namespace App\Http\Controllers\Api\Branch\Delivery;

use App\Trait\ApiTrait;
use App\Models\Delivery;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\DeliveryResource;
use App\Http\Requests\Delivery\StoreDeliveryRequest;
use App\Http\Requests\Delivery\UpdateDeliveryRequest;

class DeliveryController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $this->authorize('view delivers');
        $query = Delivery::where('company_id', auth('company')->id() ?? auth('worker')->user()->company->id)
            ->with(['employee', 'branch']);

        if ($request->has('type')) {
            $query->when($request->type === 'outer', function ($query) {
                return $query->whereNull('employee_id');
            })->when($request->type !== 'outer', function ($query) {
                return $query->whereNotNull('employee_id');
            });
        }
        return $this->apiResponse(data: DeliveryResource::collection($query->get()));
    }

    public function show(Delivery $delivery)
    {
        $this->authorize('show delivers');

        $delivery->load(['employee', 'branch']);
        return $this->apiResponse(data: new DeliveryResource($delivery));
    }

    public function store(StoreDeliveryRequest $request)
    {
        $this->authorize('create delivers');

        return $this->apiResponse(
            data: new DeliveryResource(Delivery::create($request->validated())),
            message: __('messages.delivery_created_successfully')
        );
    }

    public function update(UpdateDeliveryRequest $request, Delivery $delivery)
    {
        $this->authorize('edit delivers');

        $delivery->update($request->validated());
        return $this->apiResponse(
            data: new DeliveryResource($delivery),
            message: __('messages.delivery_updated_successfully')
        );
    }

    public function destroy(Delivery $delivery)
    {
        $this->authorize('delete delivers');

        $delivery->delete();
        return $this->apiResponse(message: __('messages.delivery_deleted_successfully'));
    }
}
