<?php

namespace App\Http\Controllers\Api\Branch\Setting;

use App\Events\GroupSettingEvent;
use App\Models\GroupSetting;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Setting\StoreGroupSettingRequest;
use App\Http\Requests\Api\Setting\UpdateGroupSettingRequest;
use App\Models\Company;
use App\Trait\ApiTrait;

class GroupSettingController extends Controller
{

    use ApiTrait;

    public function index()
    {
        $company = Company::find(auth()->id());
        $group_settings = $company->groupSettings;
        return $this->apiResponse(data:$group_settings );
    }

    public function store(StoreGroupSettingRequest $request)
    {
        $company = Company::find(auth()->id());
        $group_setting = $company->groupSettings()->create($request->validated());
        event(new GroupSettingEvent($group_setting));
        return $this->apiResponse(data:$group_setting );
    }

    public function show(GroupSetting $groupSetting)
    {
        //
    }

    public function update(UpdateGroupSettingRequest $request, GroupSetting $groupSetting)
    {
        $group_setting = $groupSetting->update($request->validated());
        return $this->apiResponse(data:$group_setting , message:'Group Settings updated successfully.');

    }

    public function destroy(GroupSetting $groupSetting)
    {
        $groupSetting->delete();
        return $this->apiResponse(message:'Group Settings deleted successfully.');
    }
}
