<?php

namespace App\Http\Controllers\Api\Branch\Setting;

use Validator;
use App\Models\Company;
use App\Trait\ApiTrait;
use App\Models\GroupSetting;
use App\Models\GroupSubSetting;
use App\Models\BranchMainSettings;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Setting\GroupSubSetting\StoreGroupSubSettingRequest;
use App\Http\Requests\Api\Setting\GroupSubSetting\UpdateGroupSubSettingRequest;
use Illuminate\Validation\ValidationException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class GroupSubSettingController extends Controller
{
    use ApiTrait;

    public function show(GroupSetting $groupSetting, BranchMainSettings $branchMainSetting)
    {
        $sub_settings = $groupSetting->subSettings()->whereIn('branch_sub_settings_id', $branchMainSetting->subSettings->pluck('id'))->get();
        return $this->apiResponse(data: $sub_settings);
    }

    public function update(UpdateGroupSubSettingRequest $request, GroupSetting $groupSetting, BranchMainSettings $branchMainSetting)
    {
        $rules = $branchMainSetting->subSettings->pluck('rules', 'id');
        $group_sub_settings = $groupSetting->subSettings()->whereIn('branch_sub_settings_id', $branchMainSetting->subSettings->pluck('id'))->get();

        $errors = [];
        $data = collect($request->settings);

        foreach ($rules as $key => $rule) {

            $value = $data->where('branch_sub_settings_id', $key)->first();
            $validator = Validator::make(
                ['value' => $value['value'] ?? null],
                ['value' => $rule]
            );

            if (!is_null($value['id'] ?? null) && !$group_sub_settings->contains($value['id'] )) {
                throw new NotFoundHttpException;
            } elseif ($validator->fails()) {
                // $errors[$key] = $validator->errors()->first();
                $errors["error_$key"] = $validator->errors()->first();
            }
        }

        if (!empty($errors)) {
            throw  ValidationException::withMessages($errors);
        }

        foreach($data as  $value)
        {
            $sub_setting = GroupSubSetting::find($value['id']);
            $sub_setting->update([
                'value' => $value['value'],
            ]);
        }

        return $this->apiResponse(message: "Settings updated successfully.");
    }
}
