<?php

namespace App\Http\Controllers\Api\Branch\Warehouse;

use App\Trait\ApiTrait;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Services\Account\OpenBalanceService;
use App\Http\Requests\Api\OpenBalance\StoreOpenBalanceRequest;
use App\Http\Requests\UpdateOpenBalanceRequest;
use App\Http\Resources\OpenBalanceResource;
use App\Models\OpenBalance;

class OpenBalanceController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(data: OpenBalanceResource::collection(OpenBalance::where('company_id', CompanyHelper::getId())->get()));
    }

    public function show(OpenBalance $openBalance)
    {
        $openBalance->load([
            'branch',
            'warehouse',
            'products.product.units',
        ]);
        return $this->apiResponse(data: OpenBalanceResource::make($openBalance));
    }

    public function store(StoreOpenBalanceRequest $request)
    {
        $this->authorize('create open balance');

        OpenBalanceService::createOpenBalance($request->products, $request->branch_id, $request->warehouse_id, $request->date, $request->description, $request->status);

        return $this->apiResponse(message: __('messages.open_balance_created_successfully'));
    }
    public function update(UpdateOpenBalanceRequest $request, OpenBalance $openBalance)
    {
        OpenBalanceService::updateOpenBalance($request->validated(), $openBalance);
        return $this->apiResponse(message: __('messages.open_balance_updated_successfully'));
    }

    public function delete(OpenBalance $openBalance)
    {
        OpenBalanceService::deleteOpenBalance($openBalance);
        return $this->apiResponse(message: __('messages.open_balance_deleted_successfully'));
    }
}
