<?php

namespace App\Http\Controllers\Api\Branch\Warehouse;

use App\Models\Bill;
use App\Models\Journal;
use App\Models\Product;
use App\Trait\ApiTrait;
use App\Models\Warehouse;
use App\Models\StockTransfer;
use App\Models\ProductWarehouse;
use App\Http\Helper\AccountHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\JournalResource;
use App\Http\Resources\ProductQuantityTrackResource;
use App\Http\Resources\ProductResource;
use App\Http\Resources\WarehouseResource;
use App\Http\Services\Account\AccountService;

class ProductWarehouseController extends Controller
{
    use ApiTrait;

    public function show(Warehouse $warehouse, Product $product)
    {
        $this->authorize('show product warehouse');

        $warehouse->load(['branches']);

        $product->load([
            'productQuantityTracks' => fn ($q) => $q->whereHas('productWarehouse', fn ($query) => $query->where('warehouse_id', $warehouse->id)),
            'productQuantityTracks.journal',
            'productQuantityTracks.productUnit',
            'warehouses' => fn ($query) => $query->where('warehouse_id', $warehouse->id),
            'units' => fn ($query) => $query->orderBy('conversion_factor'),
        ]);

        return $this->apiResponse(
            data: [
                'warehouse' => WarehouseResource::make($warehouse),
                'product' => ProductResource::make($product),
                'product_quantities_tracks' => ProductQuantityTrackResource::collection($product->productQuantityTracks)
            ]
        );
    }
}
