<?php

namespace App\Http\Controllers\Api\Category;

use App\Models\Category;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\StoreCategoryRequest;
use App\Http\Requests\UpdateCategoryRequest;
use App\Http\Resources\CategoryResource;
use App\Trait\ApiTrait;

class CategoryController extends Controller
{
    use ApiTrait;

    public function index($type)
    {
        $this->authorize('view categories');

        if ($type == 'all') {
            $categories = CompanyHelper::getCompany()->categories;
        } elseif ($type == 'products') {
            $categories = CompanyHelper::getCompany()->productsCategories;
        } elseif ($type == 'fast-services') {
            $categories = CompanyHelper::getCompany()->servicesCategories->where('fast', 1);
        } else {
            $categories = CompanyHelper::getCompany()->servicesCategories;
        }

        return $this->apiResponse(data: CategoryResource::collection($categories));
    }

    public function store(StoreCategoryRequest $request)
    {
        $this->authorize('create categories');

        $category = Category::create($request->validated());
        $category = new CategoryResource($category);

        return $this->apiResponse(
            data: $category,
            message: __('messages.category_created_successfully')
        );
    }
    public function update(UpdateCategoryRequest $request, $type,  Category $category)
    {
        $this->authorize('edit categories');

        $category->update($request->validated());
        $category = new CategoryResource($category);
        return $this->apiResponse(
            message: __('messages.category_updated_successfully'),
            data: $category
        );
    }

    public function destroy($type, Category $category)
    {
        $this->authorize('delete categories');

        $category->delete();
        return $this->apiResponse(
            message: __('messages.category_deleted_successfully'),
        );
    }
}
