<?php

namespace App\Http\Controllers\Api\Client\Attribute;

use App\Models\Attribute;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\Api\Attribute\StoreAttributeRequest;
use App\Http\Requests\Api\Attribute\UpdateAttributeRequest;
use App\Http\Resources\AttributesResource;
use App\Trait\ApiTrait;

class AttributeController extends Controller
{
    use ApiTrait;

    public function index($model, $type)
    {
        $this->authorize('create attributes');

        return $this->apiResponse(
            data: AttributesResource::collection(CompanyHelper::getCompany()->clientAttributes($type, $model)->get())
        );
    }

    public function show($model, $type, Attribute $attribute)
    {
        $this->authorize('show attributes');

        return $this->apiResponse(data: AttributesResource::make($attribute));
    }

    public function store($model, StoreAttributeRequest $request)
    {
        $this->authorize('create attributes');

        return $this->apiResponse(
            data: AttributesResource::make(AttributesResource::make(
                Attribute::create(
                    [
                        'type' => $request->type,
                        'model' => $model,
                        'company_id' => CompanyHelper::getId()
                    ] + $request->validated()
                )
            )),
            message: __('messages.attribute_created_successfully')
        );
    }

    public function update($model, $type, UpdateAttributeRequest $request, Attribute $attribute)
    {
        $this->authorize('edit attributes');

        $attribute->update($request->validated());

        return $this->apiResponse(
            data: AttributesResource::make($attribute),
            message: __('messages.attribute_updated_successfully')
        );
    }

    public function destroy($model, $type, Attribute $attribute)
    {
        $this->authorize('delete attributes');

        $attribute->delete();
        return $this->apiResponse(message: __('messages.attribute_deleted_successfully'));
    }
}
