<?php

namespace App\Http\Controllers\Api\Client\BlockClient;

use App\Trait\ApiTrait;
use App\Models\BlockClient;
use App\Http\Controllers\Controller;
use App\Http\Enums\User\UserStatusEnum;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\Api\Client\BlockClient\StoreBlockClientRequest;
use App\Http\Requests\Api\Client\BlockClient\UpdateBlockClientRequest;
use App\Http\Resources\BlockClientResource;

class BlockClientController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view block clients');

        return $this->apiResponse(
            data: BlockClientResource::collection(
                CompanyHelper::getCompany()
                    ->blockClients()
                    ->with(['client', 'blockReason'])
                    ->get()
            )
        );
    }

    public function store(StoreBlockClientRequest $request)
    {
        $this->authorize('create block clients');

        $blockClient = CompanyHelper::getCompany()->blockClients()->create(['company_id' => CompanyHelper::getId()] + $request->validated());
        $blockClient->client()->update(['status' => UserStatusEnum::BLOCKED->value]);

        return $this->apiResponse(
            data: BlockClientResource::make($blockClient),
            message: __('messages.client_added_to_block_list_successfully')
        );
    }

    public function update(UpdateBlockClientRequest $request, BlockClient $blockClient)
    {
        $this->authorize('edit block clients');

        $blockClient->update($request->validated());

        return $this->apiResponse(
            data: BlockClientResource::make($blockClient),
            message: __('messages.client_in_block_list_data_updated_successfully')
        );
    }

    public function destroy(BlockClient $blockClient)
    {
        $this->authorize('delete block clients');

        $blockClient->client()->update(['status' => UserStatusEnum::INACTIVE->value]);
        $blockClient->delete();

        return $this->apiResponse(
            message: __('messages.client_removed_from_block_list_successfully')
        );
    }
}
