<?php

namespace App\Http\Controllers\Api\Company\Attendance;
use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Company;
use App\Trait\ApiTrait;
use App\Models\Attendance;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\EmployeeAttendRequest;
use App\Http\Requests\EmployeeDepartureRequest;
use App\Http\Resources\AttendanceResource;
use App\Http\Services\Attendance\AttendanceService;
use App\Models\Employee;
use App\Http\Resources\EmployeeResource;

class AttendanceController extends Controller
{
      use ApiTrait;

    public function index()
    {
  
        $this->authorize("view attendances");
        $request = request();

        // Get date,month
        $date = $request->query('date');
        $month = $request->query('month');
    
        // Initialize the query
        $query = Attendance::query();
    
        // If year, month, and day are provided
        if ($month ) {
          $query->whereMonth('start_date', $month);;
        }
    
        if ($date ) {
        $query->whereDate('start_date', $date);;
        }
    
        // If no parameters are provided, default to today's date
        if (!$date && !$month) {
            $query->whereDate('start_date', Carbon::today());
        }
    
        // Execute the query and get the results
        $attendances = $query->with('employee')->get();
    
        // Return the API response using a resource collection
        return $this->apiResponse(data: AttendanceResource::collection($attendances));
    }
    public function show(Attendance $attendance)
    {
        $this->authorize("show attendances");

    return $this->apiResponse(data: AttendanceResource::make($attendance));
    }

    public function store(EmployeeAttendRequest $request)
    {
        $this->authorize("store attendances");
        if (Attendance::where('employee_id', $request->employee_id)->where('start_date', $request->start_date)->first()) {
            return $this->apiResponse(message: __('messages.employee_attend_Failed'), code: 400);
        }
       

        Attendance::create( $request->validated());
        return $this->apiResponse(message: __('messages.employee_attend_successfully'));
    }

    public function departure(EmployeeDepartureRequest $request)
    {
        $this->authorize("departure attendances");
    $employee_id=$request->employee_id;
        $attendance=Attendance::where("employee_id",$employee_id)
        ->where("start_date", Carbon::today())->first();
        if(!$attendance){
            return $this->apiResponse(message: __('messages.employee_not_attendance_successfully'));
        }
        $attendance->update($request->validated());
        return $this->apiResponse(message: __('messages.employee_depart_successfully'));
    }

    public function update(EmployeeAttendRequest $request,Attendance $attendance)
    {

        $this->authorize("edit attendances");
       
       

        $attendance->update( $request->validated());
        return $this->apiResponse(message: __('messages.employee_attend_successfully'));
    }


    public function destroy(Attendance $attendance){
        $this->authorize("destroy attendances");
        $attendance->delete();
        return $this->apiResponse(message: __('messages.employee_deleted_successfully'));

    }


    public function employeeshAttendanceToday(){

        $this->authorize("employees attendances");
   
        $employees = Employee::whereHas('attendances', function ($query) {
            $query->whereDate('start_date', Carbon::today());
        })->get();

        return $this->apiResponse(data: EmployeeResource::collection($employees));

    }
}
