<?php

namespace App\Http\Controllers\Api\Company\Currency;

use App\Models\Company;
use App\Trait\ApiTrait;
use App\Models\CompanyCurrency;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\CurrencyResource;
use App\Http\Requests\Api\Company\Currency\StoreCompanyCurrencyRequest;
use App\Http\Requests\Api\Company\Currency\UpdateCompanyCurrencyRequest;

class CompanyCurrencyController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view currencies');
        return $this->apiResponse(data: CurrencyResource::collection(CompanyHelper::getCompany()->currencies));
    }

    public function store(StoreCompanyCurrencyRequest $request)
    {
        $this->authorize('create currencies');

        return $this->apiResponse(
            data: CurrencyResource::make(CompanyHelper::getCompany()->currencies()->create($request->validated())),
            message: __('messages.currency_created_successfully')
        );
    }

    public function update(UpdateCompanyCurrencyRequest $request, CompanyCurrency $companyCurrency)
    {
        $this->authorize('edit currencies');

        $companyCurrency->update($request->validated());

        return $this->apiResponse(
            data: CurrencyResource::make($companyCurrency),
            message: __('messages.currency_updated_successfully')
        );
    }

    public function destroy(CompanyCurrency $companyCurrency)
    {
        $this->authorize('delete currencies');

        $companyCurrency->delete();

        return $this->apiResponse(message: __('messages.currency_deleted_successfully'));
    }
}
