<?php

namespace App\Http\Controllers\Api\Company\Excel;

use App\Http\Controllers\Controller;
use App\Http\Requests\ImportRequest;
use App\Http\Services\ImportService;
use App\Http\Services\ProductsImportService;
use App\Imports\CategoryImport;
use App\Imports\ClientsImport;
use App\Imports\ProductsImport;
use App\Imports\SuppliersImport;
use App\Trait\{ApiTrait};
use Illuminate\Support\Facades\DB;

class ImportController extends Controller
{
    use ApiTrait;
    protected $importService;
    public function __construct(ImportService $importService)
    {
        $this->importService = $importService;
    }
    public function importClients(ImportRequest $request)
    {
        $this->importService->ImportExcelFile(new ClientsImport, $request);
        return $this->apiResponse(message: __('messages.clients_imported_successfully'));
    }

    public function importSuppliers(ImportRequest $request)
    {
        $this->importService->ImportExcelFile(new SuppliersImport, $request);
        return $this->apiResponse(message: __('messages.suppliers_imported_successfully'));
    }
    public function importProducts(ImportRequest $request)
    {
        $productsImportService = new ProductsImportService();
        DB::beginTransaction();
        $this->importService->ImportExcelFile(new ProductsImport($productsImportService), $request);
        $productsImportService->createImportJournal();
        DB::commit();
        return $this->apiResponse(message: __('messages.products_imported_successfully'));
    }
    public function importServices(ImportRequest $request)
    {
        $this->importService->ImportExcelFile(new SuppliersImport, $request);
        return $this->apiResponse(message: __('messages.services_imported_successfully'));
    }
    public function importRegions(ImportRequest $request)
    {
        $this->importService->ImportExcelFile(new SuppliersImport, $request);
        return $this->apiResponse(message: __('messages.regions_imported_successfully'));
    }
    public function importCategories(ImportRequest $request)
    {
        $this->importService->ImportExcelFile(new CategoryImport, $request);
        return $this->apiResponse(message: __('messages.regions_imported_successfully'));
    }
}
