<?php

namespace App\Http\Controllers\Api\Company\Expense;

use App\Models\Expense;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\ExpenseResource;
use App\Http\Requests\Api\Company\Expense\ExpenseRequest;

class ExpenseController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(data: ExpenseResource::collection(CompanyHelper::getCompany()->expenses()->with(['account'])->get()));
    }

    public function show(Expense $expense)
    {
        $expense->load(['account']);
        return $this->apiResponse(data: ExpenseResource::make($expense));
    }

    public function store(ExpenseRequest $request)
    {
        $expense = CompanyHelper::getCompany()->expenses()->create($request->validated());
        return $this->apiResponse(message: 'Expense created successfully');
    }

    public function update(ExpenseRequest $request, Expense $expense)
    {
        $expense->update($request->validated());
        return $this->apiResponse(message: 'Expense updated successfully');
    }

    public function destroy(Expense $expense)
    {
        $expense->delete();
        return $this->apiResponse(message: 'Expense deleted successfully');
    }
}
