<?php

namespace App\Http\Controllers\Api\Company\Journal;

use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\HandleNotificationRequest;
use App\Http\Requests\PostponeNotificationRequest;
use App\Http\Requests\UpdateJournalRepeationRequest;
use App\Http\Resources\JournalRepeationNotificationsResource;
use App\Http\Resources\JournalRepeationResource;
use App\Http\Services\Account\JournalRepeationService;
use App\Models\JournalRepeationNotification;
use App\Models\JournalReptation;
use Illuminate\Http\Request;
use App\Http\Services\Account\JournalService;

class JournalRepeationController extends Controller
{
    public function index()
    {
        return $this->apiResponse(data: JournalRepeationResource::collection(JournalReptation::where('company_id', CompanyHelper::getId())->get()));
    }

    public function destroy(JournalReptation $journalReptation)
    {
        JournalRepeationNotification::where('journal_repeation_id', $journalReptation->id)->delete();
        $journalReptation->delete();
        return $this->apiResponse(message: __('messages.journal_reptation_deleted_successfully'));
    }

    public function update(UpdateJournalRepeationRequest $request, JournalReptation $journalReptation)
    {
        // $journalReptation->timestamps = false;
        // $journalReptation->update($request->validated());
        // $journalReptation->timestamps = true;
        // return $this->apiResponse(message: __('messages.journal_reptation_updated_successfully'));

        (new JournalService())->updateJournal(
            $request,
            $journalReptation->journal,
            $journalReptation,
             repeatable: false,
            status: $request->status,
              repeatableData:[],
        );
        return $this->apiResponse(
            message: __('messages.journal_updated_successfully'),
        );
    }

    public function getNotifications()
    {
        return $this->apiResponse(data: JournalRepeationNotificationsResource::collection(JournalRepeationService::getNotifications()));
    }

    public function handleNotification(HandleNotificationRequest $request)
    {
        $message = JournalRepeationService::handelNotification($request) ? __('messages.journal_repeated_successfully') : __('messages.journal_repeated_canceled');
        return $this->apiResponse(message: $message);
    }

    public function copyJournalRepeation(Request $request, JournalReptation $journalReptation)
    {
        $newRowData = $journalReptation->toArray();
        unset($newRowData['id']);
        $newRowData['is_expired'] = 0;
        $newRowData['start_date'] = $request->input('start_date');
        $newRowData['end_date'] = $request->input('end_date');
        JournalReptation::create($newRowData);
        return $this->apiResponse(message: __('messages.journal_reptation_copied_successfully'));
    }


    public function postponeNotification(JournalRepeationNotification $journalReptationNotification, PostponeNotificationRequest $request)
    {
        $journalReptationNotification->update([
            'date' => $request->date
        ]);
        return $this->apiResponse(message: __('messages.journal_reptation_notification_postponed_successfully'));
    }
}
