<?php

namespace App\Http\Controllers\Api\Company\PaymentMethod;

use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\Api\Company\PaymentMethod\StorePaymentMethodRequest;
use App\Http\Requests\Api\Company\PaymentMethod\UpdatePaymentMethodRequest;
use App\Http\Resources\PaymentMethodResource;
use App\Models\PaymentMethod;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;

class PaymentMethodController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $this->authorize('view payment methods');

        return $this->apiResponse(data: [
            "all" => PaymentMethodResource::collection(PaymentMethod::get()),
            "own" => PaymentMethodResource::collection(CompanyHelper::getCompany($request)->paymentMethods()->with('paymentMethodTypes')->get()),
        ]);
    }

    public function store(StorePaymentMethodRequest $request)
    {
        $this->authorize('create payment methods');

        CompanyHelper::getCompany($request)->paymentMethods()->sync($request->payment_methods);
        return $this->apiResponse(
            message: __('messages.payment_method_updated_successfully')
        );
    }

    // public function show(PaymentMethod $paymentMethod)
    // {
    //     return $this->apiResponse(data: new PaymentMethodResource($paymentMethod));
    // }

    // public function update(UpdatePaymentMethodRequest $request, PaymentMethod $paymentMethod)
    // {
    //     $paymentMethod->update($request->validated());
    //     return $this->apiResponse(
    //         data: new PaymentMethodResource($paymentMethod),
    //         message: "Payment Method created successfully."
    //     );
    // }

    // public function destroy(PaymentMethod $paymentMethod)
    // {
    //     $paymentMethod->delete();
    //     return $this->apiResponse(
    //         message: "Payment Method deleted successfully."
    //     );
    // }
}
