<?php

namespace App\Http\Controllers\Api\Company\PaymentTerm;

use App\Trait\ApiTrait;
use App\Models\PaymentTerm;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Company\PaymentTerm\StorePaymentTermRequest;
use App\Http\Requests\Api\Company\PaymentTerm\UpdatePaymentTermRequest;
use App\Http\Resources\PaymentTermResource;

class PaymentTermController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $paymentTerms = PaymentTermResource::collection($request->user()->paymentTerms);
        return $this->apiResponse(data: $paymentTerms);
    }

    public function show(PaymentTerm $paymentTerm)
    {
        return $this->apiResponse(data: new PaymentTermResource($paymentTerm));
    }

    public function store(StorePaymentTermRequest $request)
    {
        $paymentTerm = new PaymentTermResource($request->user()->paymentTerms()->create($request->validated()));
        return $this->apiResponse(data: $paymentTerm, message: "Payment Term created successfully.");
    }

    public function update(UpdatePaymentTermRequest $request, PaymentTerm $paymentTerm)
    {
        $paymentTerm->update($request->validated());
        return $this->apiResponse(data: new PaymentTermResource($paymentTerm), message: "Payment Term updated successfully.");
    }

    public function destroy(PaymentTerm $paymentTerm)
    {
        $paymentTerm->delete();
        return $this->apiResponse(message: "Payment Term deleted successfully.");
    }
}
