<?php

namespace App\Http\Controllers\Api\Company\PermissionRequest;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Models\PermissionRequest;
use App\Http\Controllers\Controller;
use App\Http\Resources\PermissionRequestResource;
use App\Http\Requests\Api\Company\PermissionRequest\StorePermissionRequestRequest;
use App\Http\Requests\Api\Company\PermissionRequest\UpdatePermissionRequestRequest;

class PermissionRequestController extends Controller
{
    use ApiTrait; // change status

    public function index(Request $request)
    {
        $permission_requests = PermissionRequestResource::collection($request->user()->permissionRequests()->with('employee')->get());
        return $this->apiResponse(data: $permission_requests);
    }

    public function store(StorePermissionRequestRequest $request)
    {
        $permission_request = new PermissionRequestResource($request->user()->permissionRequests()->create($request->validated()));
        return $this->apiResponse(data: $permission_request, message: __('messages.permission_request_stored_successfully'));
    }

    public function show(PermissionRequest $permissionRequest)
    {
        $permissionRequest->load([
            'employee',
        ]);
        $permissionRequest = new PermissionRequestResource($permissionRequest);
        return $this->apiResponse(data: $permissionRequest);
    }

    public function update(UpdatePermissionRequestRequest $request, PermissionRequest $permissionRequest)
    {
        $permissionRequest->update($request->validated());
        $permissionRequest = new PermissionRequestResource($permissionRequest);
        return $this->apiResponse(data: $permissionRequest, message: __('messages.permission_updated_successfully'));
    }

    public function destroy(PermissionRequest $permissionRequest)
    {
        $permissionRequest->delete();
        return $this->apiResponse(message: __('messages.permission_deleted_successfully'));
    }
}
