<?php

namespace App\Http\Controllers\Api\Company\Revenuse;

use App\Http\Requests\CompanyRevenuesRequest;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\MerchantRevenuesRequest;
use App\Http\Requests\RevenuesRequest;
use App\Http\Resources\CompanyRevenuesResource;
use App\Http\Resources\MerchantRevenuesResource;
use App\Http\Services\RevenuesService;
use App\Models\CompanyRevenues;
use App\Models\MerchantRevenues;
use App\Models\Company;

class RevenuesController extends Controller
{


    public function getCompanyRevenues(RevenuesRequest $request)
    {

        $this->authorize('view company_revenues');
        $query = CompanyRevenues::where('type', $request->type)
            ->where('company_id', CompanyHelper::getId());

        if ($request->paymentMethod) {
            $query->where($request->paymentMethod, '>', 0);
        }
        if ($request->code) {
            $query->where('code', $request->code);
        }
        if ($request->from) {
            $query->where('date', '>=', $request->from);
        }
        if ($request->to) {
            $query->where('date', '<=', $request->to);
        }
        $revenues = $query->get();

        return $this->apiResponse(data: CompanyRevenuesResource::collection($revenues));
    }

    public function getMerchantsRevenues(RevenuesRequest $request)
    {
        $this->authorize('view merchant_revenues');
        $query = MerchantRevenues::where('type', $request->type)
            ->where('company_id', CompanyHelper::getId());

        if ($request->paymentMethod) {
            $query->where($request->paymentMethod, '>', 0);
        }
        if ($request->code) {
            $query->where('code', $request->code);
        }
        if ($request->from) {
            $query->where('date', '>=', $request->from);
        }
        if ($request->to) {
            $query->where('date', '<=', $request->to);
        }

        $revenues = $query->get();

        return $this->apiResponse(data: MerchantRevenuesResource::collection($revenues));
    }

    public function storeCompanyRevenues(CompanyRevenuesRequest $request)
    {
        RevenuesService::create($request, CompanyRevenues::class);

        return $this->apiResponse(message: 'Company Revenues created successfully');
    }
    public function storeMerchantRevenues(MerchantRevenuesRequest $request)
    {
        RevenuesService::create($request, MerchantRevenues::class);
        return $this->apiResponse(message: 'Merchant Revenues created successfully');
    }
}
