<?php

namespace App\Http\Controllers\Api\Company\Role;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Resources\RoleResource;
use App\Http\Requests\Api\Company\Role\StoreRoleRequest;
use App\Http\Requests\Api\Company\Role\AttachPermissionRequest;
use App\Http\Requests\Api\Company\Role\AttachWorkerPermissionRequest;
use App\Models\Worker;
use Spatie\Permission\Models\Permission;

class RoleController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view roles');

        return $this->apiResponse(data: RoleResource::collection(CompanyHelper::getCompany()->roles));
    }

    public function show(Role $role)
    {
        $this->authorize('show roles');

        $role->load('permissions');

        return $this->apiResponse(data: RoleResource::make($role));
    }

   public function store(StoreRoleRequest $request)
    {
        $this->authorize('create roles');

        $role=Role::create([
                    'name' => $request->name,
                    'guard_name' => 'worker',
                    'company_id' => CompanyHelper::getId()
        ]);
        if ($request->has('permissions') && is_array($request->permissions)) {
            $permissions = $request->all === 1 ? Permission::where('guard_name', 'worker')->pluck('id')->toArray() : $request->permissions;
            $role->syncPermissions( $permissions);
        }
    
        $role->load('permissions');
    
        // Return a response
        return $this->apiResponse(
            data: new RoleResource($role),
            message: __('messages.role_created_successfully')
        );

        // return $this->apiResponse(data: RoleResource::make(
        //     Role::create([
        //         'name' => $request->name,
        //         'guard_name' => 'worker',
        //         'company_id' => CompanyHelper::getId()
        //     ])
        // ));
    }

    public function destroy(Role $role)
    {
        $this->authorize('delete roles');

        $role->delete();

        return $this->apiResponse(message: __('messages.role_deleted_successfully'));
    }

    public function attachPermissions(AttachPermissionRequest $request, Role $role)
    {

        $this->authorize('edit roles');
        $permissions = $request->all === 1 ? Permission::where('guard_name', 'worker')->pluck('id')->toArray() : $request->permissions;
        $role->syncPermissions($permissions);
        $role->load('permissions');

        return $this->apiResponse(message: __('messages.permission_attached_to_role_successfully'));
    }

    public function attachWorkerPermission(AttachWorkerPermissionRequest $request, Worker $worker)
    {
        $worker->syncPermissions($request->permissions);

        return $this->apiResponse(message: __('messages.permission_attached_to_worker_successfully'));
    }
}
