<?php

namespace App\Http\Controllers\Api\Company\ShipmentCompany;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Company\ShipmentCompany\StoreShipmentCompanyRequest;
use App\Http\Requests\Api\Company\ShipmentCompany\UpdateShipmentCompanyRequest;
use App\Http\Resources\ShipmentCompanyResource;
use App\Models\ShipmentCompany;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;

class ShipmentCompanyController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $shipmentCompanies = ShipmentCompanyResource::collection($request->user()->shipmentCompanies);
        return $this->apiResponse(data: $shipmentCompanies);
    }

    public function store(StoreShipmentCompanyRequest $request)
    {
        $shipmentCompany = new ShipmentCompanyResource($request->user()->shipmentCompanies()->create($request->validated()));
        return $this->apiResponse(data: $shipmentCompany, message: "Shipment company created successfully.");
    }

    public function show(ShipmentCompany $shipmentCompany)
    {
        return $this->apiResponse(data: new ShipmentCompanyResource($shipmentCompany));
    }

    public function update(UpdateShipmentCompanyRequest $request, ShipmentCompany $shipmentCompany)
    {
        $shipmentCompany->update($request->validated());
        return $this->apiResponse(data: new ShipmentCompanyResource($shipmentCompany), message: "Shipment Company updated successfully.");
    }

    public function destroy(ShipmentCompany $shipmentCompany)
    {
        $shipmentCompany->delete();
        return $this->apiResponse(message: "Shipment Company deleted successfully.");
    }
}
