<?php

namespace App\Http\Controllers\Api\Company\Tax;

use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\Api\Company\Tax\StoreTaxRequest;
use App\Http\Requests\Api\Company\Tax\UpdateTaxRequest;
use App\Http\Resources\TaxResource;
use App\Models\Tax;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;

class TaxController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $this->authorize('view taxes');

        return $this->apiResponse(
            data: TaxResource::collection(CompanyHelper::getCompany()->taxes)
        );
    }

    public function show(Tax $tax)
    {
        $this->authorize('show taxes');

        return $this->apiResponse(
            data: TaxResource::make($tax)
        );
    }

    public function store(StoreTaxRequest $request)
    {
        $this->authorize('create taxes');

        return $this->apiResponse(
            data: TaxResource::make(CompanyHelper::getCompany()->taxes()->create($request->validated())),
            message: __('messages.tax_created_successfully')
        );
    }

    public function update(UpdateTaxRequest $request, Tax $tax)
    {
        $this->authorize('edit taxes');

        $tax->update($request->validated());

        return $this->apiResponse(
            data: TaxResource::make($tax),
            message: __('messages.tax_updated_successfully')
        );
    }

    public function destroy(Tax $tax)
    {
        $this->authorize('delete taxes');

        $tax->delete();

        return $this->apiResponse(
            message: __('messages.tax_deleted_successfully')
        );
    }
}
