<?php

namespace App\Http\Controllers\Api\Company\Unit;

use App\Models\Company;
use App\Trait\ApiTrait;
use App\Models\MainUnit;
use App\Models\CompanyUnit;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\Api\Company\Unit\StoreCompanyUnitRequest;
use App\Http\Requests\Api\Company\Unit\UpdateCompanyUnitRequest;
use App\Http\Resources\UnitResource;

class CompanyUnitController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view units');

        return $this->apiResponse(data: UnitResource::collection(CompanyHelper::getCompany()->units));
    }

    public function store(StoreCompanyUnitRequest $request)
    {
        $this->authorize('create units');

        return $this->apiResponse(
            data: UnitResource::make(CompanyHelper::getCompany()->units()->create($request->validated())),
            message: __('messages.unit_created_successfully')
        );
    }

    public function update(UpdateCompanyUnitRequest $request, CompanyUnit $companyUnit)
    {
        $this->authorize('edit units');

        $companyUnit->update($request->validated());

        return $this->apiResponse(
            data: UnitResource::make($companyUnit),
            message: __('messages.unit_updated_successfully')
        );
    }

    public function destroy(CompanyUnit $companyUnit)
    {
        $this->authorize('delete units');

        $companyUnit->delete();

        return $this->apiResponse(message: __('messages.unit_deleted_successfully'));
    }
}
