<?php

namespace App\Http\Controllers\Api\Company\VacationRequest;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Models\VacationRequest;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Resources\VacationRequestResource;
use App\Http\Requests\Api\Company\VacationRequest\StoreVacationRequestRequest;
use App\Http\Requests\Api\Company\VacationRequest\UpdateVacationRequestRequest;
use App\Http\Requests\Api\Company\VacationRequest\ChangeVacationRequestStatusRequest;
use App\Http\Services\ApiNotificationService;
use App\Models\Employee;

class VacationRequestController extends Controller
{
    use ApiTrait;

    public function index()
    {
        if (auth('employee')->check()) {
            return $this->apiResponse(data: VacationRequestResource::collection(VacationRequest::where('employee_id', auth()->user()->id)->latest()
->get()));
        }
        $this->authorize('view vacation requests');
        return $this->apiResponse(data: VacationRequestResource::collection(VacationRequest::where('company_id', CompanyHelper::getId())->with(['employee'])->latest()
->get()));
    }

    public function show(VacationRequest $vacationRequest)
    {
        $this->authorize('show vacation requests');

        $vacationRequest->load([
            'employee',
          
        ]);
        $vacationRequest = new VacationRequestResource($vacationRequest);
        return $this->apiResponse(data: $vacationRequest);
    }

    public function store(StoreVacationRequestRequest $request)
    {
        if (auth('employee')->check()) {
            VacationRequest::create($request->validated());
            return $this->apiResponse(message: __('messages.vacation_request_created_successfully'));
        }
        $this->authorize('create vacation requests');
        $vacationRequest = new VacationRequestResource($request->user()->vacationRequests()->create($request->validated()));
        return $this->apiResponse(data: $vacationRequest, message: __('messages.vacation_request_created_successfully'));
    }

    public function update(UpdateVacationRequestRequest $request, VacationRequest $vacationRequest)
    {
        $this->authorize('edit vacation requests');

        $vacationRequest->update($request->validated());
        $vacationRequest = new VacationRequestResource($vacationRequest);
        return $this->apiResponse(data: $vacationRequest, message: __('messages.vacation_request_updated_successfully'));
    }

    public function changeStatus(ChangeVacationRequestStatusRequest $request, VacationRequest $vacationRequest)
    {
        $this->authorize('edit vacation requests');

        $vacationRequest->update(['status' => $request->status]);
        // $fcmToken = Employee::where('id', $vacationRequest->employee_id)->pluck('fcm')->first();
        // ApiNotificationService::apiNotification('Vacation Request Update', 'Your vacation request has been ' . ($request->status ), $fcmToken);
        return $this->apiResponse(data: new VacationRequestResource($vacationRequest), message: __('messages.vacation_request_status_updated_successfully'));
    }

    public function destroy(VacationRequest $vacationRequest)
    {
        $this->authorize('delete vacation requests');

        $vacationRequest->delete();
        return $this->apiResponse(message: __('messages.vacation_request_deleted_successfully'));
    }
}
