<?php

namespace App\Http\Controllers\Api\Employee\App;
use Carbon\Carbon;
use App\Http\Controllers\Controller;
use App\Http\Requests\EmployeeAttendRequest;
use App\Http\Requests\EmployeeDepartureRequest;
use App\Http\Resources\AttendanceResource;
use App\Http\Services\Attendance\AttendanceService;
use App\Models\Attendance;
use App\Models\Departure;
use App\Trait\ApiTrait;
use App\Trait\UploadFileTrait;

class AttendanceController extends Controller
{
    use UploadFileTrait,ApiTrait;
    public function getHome()
    {
        $employee = auth()->user();
        $branch = auth()->user()->branch;
        // list($latitude, $longitude) = explode(',', $branch->location);
        return $this->apiResponse(data: [
            'id' => $employee->id,
            'name' => $employee->name,
            'working_days' => '10',
            'vacation_days' => '2',
            // 'branch' => [
            //     'id' => $branch->id,
            //     'name' => $branch->name,
            //     'latitude' => $latitude,
            //     'longitude' => $longitude,
            // ],
            'branch_working_days' => '22',
            'branch_vacation_days' => '8',
        ]);
    }
   public function attend(EmployeeAttendRequest $request)
    {
        if (Attendance::where('employee_id', auth()->user()->id)->where('start_date', $request->start_date)->where('branch_id', $request->branch_id )->first()) {
            return $this->apiResponse(message: __('messages.employee_attend_Failed'), code: 400);
        }
        $file = $this->uploadFile(Attendance::UPLOADED_FILES, $request->image);

        Attendance::create([
            'image' => $file,
        ] + $request->validated());
        return $this->apiResponse(message: __('messages.employee_attend_successfully'));
    }


    public function departure(EmployeeDepartureRequest $request)
    {
        // dd("ttt");
        $employee= auth()->user();
        if (Attendance::where("employee_id",$request->employee_id)
        ->where("end_date", Carbon::today())->where('depture_branche_id', $request->depture_branche_id )->first()) {
            return $this->apiResponse(message: __('messages.employee_depart_failed'), code: 400);
        }
       
       $attendance=Attendance::where("employee_id",$request->employee_id)
        ->where("start_date", Carbon::today())->first();
        if(!$attendance){
            return $this->apiResponse(message: __('messages.employee_not_attendance_successfully'));
        }
        $attendance->update($request->validated());
        return $this->apiResponse(message: __('messages.employee_depart_successfully'));
    }


    public function workSchedule()
{
    $request = request();
    $userId = auth()->user()->id;

    // call service 
       $attendanceEmployee= AttendanceService::mySchedule($request,$userId);
    
    return $this->apiResponse(data:$attendanceEmployee);
}

public function getEmployeeBranches()
{
 
    $branches = auth()->user()->branches; 
 
    if($branches){
        $branchesData = $branches->map(function ($branch) {
            
            if($branch->location){
                 list($latitude, $longitude) = explode(',', $branch->location);  
            return [
                'id' => $branch->id,
                'name' => $branch->name,
                'latitude' => $latitude,
                'longitude' => $longitude,
                
            ];
                
            }
          
        });

    }else{
        return $this->apiResponse(message: __('employee doesn,t have branches'));
    }
   

    return $this->apiResponse(data: [
        'branches' => $branchesData,
    ]);
}
    
}
